unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, KACDOMessage, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Edit3: TEdit;                                                                                
    Label4: TLabel;
    Edit4: TEdit;
    Label5: TLabel;
    Memo1: TMemo;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Edit5: TEdit;
    Label7: TLabel;
    Edit6: TEdit;
    SaveDialog1: TSaveDialog;
    Label8: TLabel;
    Edit7: TEdit;
    OpenDialog1: TOpenDialog;
    GroupBox2: TGroupBox;
    Button5: TButton;
    Label9: TLabel;
    Edit8: TEdit;
    Label10: TLabel;
    Edit9: TEdit;
    Label11: TLabel;
    ComboBox1: TComboBox;
    Label12: TLabel;
    ComboBox2: TComboBox;
    Button6: TButton;
    ComboBox3: TComboBox;
    Label13: TLabel;
    Label14: TLabel;
    ComboBox4: TComboBox;
    KACDOMessage1: TKACDOMessage;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure ComboBox4Click(Sender: TObject);
    procedure ComboBox4KeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure FillFields;
    Procedure RefreshFields;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

Procedure TForm1.FillFields;
Begin
  KACDOMessage1.CDO01_From      := Edit1.Text;
  KACDOMessage1.CDO03_To        := Edit2.Text;
  KACDOMessage1.CDO04_CC        := Edit3.Text;
  KACDOMessage1.CDO05_BCC       := Edit4.Text;
  KACDOMessage1.CDO06_Subject   := Edit7.Text;
  KACDOMessage1.CDO07_Body.Assign(Memo1.Lines);
  Case ComboBox3.ItemIndex of
       0 : KACDOMessage1.TextEncoding := te7Bit;
       1 : KACDOMessage1.TextEncoding := te8Bit;
       2 : KACDOMessage1.TextEncoding := teBase64;
       3 : KACDOMessage1.TextEncoding := teBinary;
       4 : KACDOMessage1.TextEncoding := teQuotedPrintable;
       5 : KACDOMessage1.TextEncoding := teUuencode;
  End;
End;

Procedure TForm1.RefreshFields;
Begin
 Edit1.Text := KACDOMessage1.CDO01_From;
 Edit2.Text := KACDOMessage1.CDO03_To;
 Edit3.Text := KACDOMessage1.CDO04_CC;
 Edit4.Text := KACDOMessage1.CDO05_BCC;
 Edit7.Text := KACDOMessage1.CDO06_Subject;
 ComboBox3.ItemIndex:=-1;
 Case KACDOMessage1.TextEncoding of
      te7Bit            : ComboBox3.ItemIndex:=0;
      te8Bit            : ComboBox3.ItemIndex:=1;
      teBase64          : ComboBox3.ItemIndex:=2;
      teBinary          : ComboBox3.ItemIndex:=3;
      teQuotedPrintable : ComboBox3.ItemIndex:=4;
      teUuencode        : ComboBox3.ItemIndex:=5;
 End;
 Memo1.Lines.Text := KACDOMessage1.CDO07_Body.Text;
End;

procedure TForm1.Button1Click(Sender: TObject);
begin
 KACDOMessage1.ManageAttachments;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 FillFields;
 SaveDialog1.FileName := KACDOMessage1.FileName;
 if SaveDialog1.Execute Then
    Begin
      KACDOMessage1.Headers.Clear;
      KACDOMessage1.SaveToFile(SaveDialog1.FileName);
    End;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 FillFields;
 KACDOMessage1.SMTPServer     := Edit5.Text;
 KACDOMessage1.SMTPServerPort := StrToInt(Edit6.Text);
 KACDOMessage1.SMTPUsername   := Edit8.Text;
 KACDOMessage1.SMTPPassword   := Edit9.Text;
 Case ComboBox1.ItemIndex of
      0 : KACDOMessage1.SMTPAuthMethod := cdo_Anonymous;
      1 : KACDOMessage1.SMTPAuthMethod := cdo_Basic;
      2 : KACDOMessage1.SMTPAuthMethod := cdo_NTLM;
 End;
 Case ComboBox2.ItemIndex of
      0 : KACDOMessage1.SMTPSendMethod := cdo_SendUsingPort;
      1 : KACDOMessage1.SMTPSendMethod := cdo_SendUsingPickup;
 End;
 KACDOMessage1.Send;
 ShowMessage('Message sent!');
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if OpenDialog1.Execute Then
    Begin
      KACDOMessage1.LoadFromFile(OpenDialog1.FileName);
      RefreshFields;
      ComboBox4.Text   := KACDOMessage1.Charset;
    End;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
 Close;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
 ///////////////////////////////////////////////////////////////////////////////
 // YOU DO NOT NEED USERNAME AND PASSWORD WITH ANONYMOUS AND NTLM AUTHENTICATION
 ///////////////////////////////////////////////////////////////////////////////
 if (ComboBox1.ItemIndex = 0) or (ComboBox1.ItemIndex = 2) Then
    Begin
      Edit8.Text := '';
      Edit9.Text := '';
    End;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
 Edit1.Text       := '';
 Edit2.Text       := '';
 Edit3.Text       := '';
 Edit4.Text       := '';
 Edit7.Text       := '';
 Memo1.Lines.Text := '';
 KACDOMessage1.NewMessage;
end;

procedure TForm1.ComboBox4Click(Sender: TObject);
begin
 Try
  FillFields;
  KACDOMessage1.Charset := ComboBox4.Text;
  RefreshFields;
 Except
 End;
end;

procedure TForm1.ComboBox4KeyPress(Sender: TObject; var Key: Char);
begin
 if Key=#13 Then
    Begin
      Key:=#0;
      Try
       FillFields;
       KACDOMessage1.Charset := ComboBox4.Text;
       RefreshFields;
      Except
      End;
    End;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 KACDOMessage1.JITCharsetCoding := True;
end;

end.
